********************************************************************************
** The ASEC income by the Monthly CPS bracket, HHs who were interviewed in both surveys

clear
cd "C:\Users\worri\Dropbox\Poverty\COVID19"
use Monthly_Poverty_0520.dta

** keep ASEC samples and interview month 1 or 5
keep if asecflag==1

gen yr_month=year*100+month   

** drop the 3/8 file in 2014 
drop if hflag==1 
** replace asecflag 2 => asecflag . 
replace asecflag=. if asecflag==2 

** drop irrelevant variables
drop hflag earnwt offcutoff qinc*d qoinc*d durunemp whyunemp whyabsnt wnlook wkstat wksworkorg occ ind classwkr earnwt earnweek
** deal with missing or N/A income data
replace inctot = 0 if inctot==999999999|inctot==.

********************************************************************************
******   Construct a family unit variable for Poverty measures, famnum    ******
** For the poverty measure, a primary family and realted family is considered as one family

/* Assign 1 to primary+realted families */
gen famnum = ftype==1|ftype==3 

/* Assign 2-4 to unrelated subfamilies */ 
sort yr_month asecflag serial ftype pernum
* Each subfamily has a reference person  (famrel==1)
//tab famrel if ftype==4
* Calculate # subfamilies in a household (Max 3 in this sample period)
bysort yr_month asecflag serial: egen tot_subfam = sum(ftype==4 & famrel==1)
tab tot_subfam if ftype==4 
sort yr_month asecflag serial ftype famrel
bysort yr_month asecflag serial ftype: gen subfamnum = sum(famrel==1)
tab subfamnum if ftype==4 
* Assign 2-4 to the 1st-3rd unrelated subfamily
replace famnum= subfamnum+1 if ftype==4 
drop subfamnum pernum

/* Assign 5-20 to non-family members (ftype=1,2 or famrel=0) */
* Calculate # non-family members within a household (Max 16 in this sample period)
bysort yr_month asecflag serial: gen non_fam = sum(famrel==0) 
tab non_fam 
* Assign 5-20 to the 1st-20th non-family member. 
replace famnum= non_fam+4 if famrel==0  
drop non_fam

* Construct demographic variables related to the poverty threshold 
* 1) family size
bysort yr_month asecflag serial famnum: gen fam_size = _N
* 2) related children under age 18 (excluding HH head or spouse)
bysort yr_month asecflag serial famnum: egen nchild = sum(age<18 & relate>=301)
* 3) the head is elderly (>=65)
bysort yr_month asecflag serial famnum: egen head_elderly = max(age>=65 & relate==101)
* 4) a few cases where all members are children -> change to one adult w/ two children 
replace nchild=nchild-1 if fam_size==nchild



********************************************************************************
** Construct the family income variable in category for the ASEC sample 

* 1) generate a flag variable for ASEC earnings 
bysort yr_month asecflag serial famnum: egen qASECinc = max(qinclong==1|qoincwage==1|qoincbus==1|qoincfarm==1)
drop qinclong qoincwage qoincbus qoincfarm
* 2) identify the HH head's family  
bysort yr_month asecflag serial famnum: egen hfam = sum(relate==101) 

* 3) calculate the Householder's family income
bysort yr_month asecflag serial: egen hfaminc = sum(inctot) if hfam==1
bysort yr_month asecflag serial: egen ASECfam_inc = max(hfaminc)
replace ASECfam_inc=. if asecflag!=1
drop inctot

* 4) create an income bracket variable based on the ASEC income value
* I will impute the income based on this variable 
gen ASECincgrp = . 
replace ASECincgrp = 100 if ASECfam_inc<5000 
replace ASECincgrp = 210 if ASECfam_inc>=5000 & ASECfam_inc<7500
replace ASECincgrp = 300 if ASECfam_inc>=7500 & ASECfam_inc<10000
replace ASECincgrp = 430 if ASECfam_inc>=10000 & ASECfam_inc<12500
replace ASECincgrp = 470 if ASECfam_inc>=12500 & ASECfam_inc<15000
replace ASECincgrp = 500 if ASECfam_inc>=15000 & ASECfam_inc<20000
replace ASECincgrp = 600 if ASECfam_inc>=20000 & ASECfam_inc<25000
replace ASECincgrp = 710 if ASECfam_inc>=25000 & ASECfam_inc<30000 
replace ASECincgrp = 720 if ASECfam_inc>=30000 & ASECfam_inc<35000
replace ASECincgrp = 730 if ASECfam_inc>=35000 & ASECfam_inc<40000 
replace ASECincgrp = 740 if ASECfam_inc>=40000 & ASECfam_inc<50000
replace ASECincgrp = 820 if ASECfam_inc>=50000 & ASECfam_inc<60000
replace ASECincgrp = 830 if ASECfam_inc>=60000 & ASECfam_inc<75000
replace ASECincgrp = 840 if ASECfam_inc>=75000 & year<=2004
replace ASECincgrp = 841 if ASECfam_inc>=75000 & ASECfam_inc<100000  & year>=2005
replace ASECincgrp = 842 if ASECfam_inc>=100000 & ASECfam_inc<150000 & year>=2005
replace ASECincgrp = 843 if ASECfam_inc>=150000 & year>=2005


** construct 15 demographic groups based on householder's family characteristics
gen gr=.
replace gr=1  if fam_size==1 & head_elderly==0
replace gr=2  if fam_size==1 & head_elderly==1
replace gr=3  if fam_size==2 & head_elderly==0 & nchild==0 
replace gr=4  if fam_size==2 & head_elderly==1 & nchild==0 
replace gr=5  if fam_size==2 & nchild==1
replace gr=6  if fam_size==3 & nchild==0
replace gr=7  if fam_size==3 & nchild==1
replace gr=8  if fam_size==3 & nchild==2
replace gr=9  if fam_size==4 & nchild<=1
replace gr=10 if fam_size==4 & nchild==2
replace gr=11 if fam_size==4 & nchild==3
replace gr=12 if fam_size==5 & nchild<=2
replace gr=13 if fam_size==5 & nchild>=3
replace gr=14 if fam_size==6 
replace gr=15 if fam_size>=7


********************************************************************************
** Family Income Imputation within income-demographic cell using the ASEC Income
*1) convert the data to the household level data  
preserve 
keep year yr_month asecflag serial relate ASECincgrp gr faminc ASECfam_inc 
* keep one obs per HH (head)
sort yr_month asecflag serial relate
bysort yr_month asecflag serial: keep if _n==1
* calculate the size of demographic cells in each ASEC income bracket 
bysort year ASECincgrp gr asecflag: gen ASEC_N = _N if asecflag==1 
bysort year ASECincgrp gr: egen N = max(ASEC_N)
drop faminc 
rename ASECincgrp faminc 
collapse N, by (yr_month asecflag faminc gr)
tempfile ASEC_N
save `ASEC_N', replace
restore

*2) within a cell, assign to monthly CPS HH a random number btw 1 and N, where N is the size of each cell in the ASEC sample
* this random number will be used when assigning ASEC income to monthly CPS households 
preserve 
keep year yr_month asecflag serial relate ASECincgrp gr faminc ASECfam_inc qASECinc
* keep one obs per HH (head)
sort yr_month asecflag serial relate
bysort yr_month asecflag serial: keep if _n==1
merge m:1 yr_month asecflag faminc gr using `ASEC_N'
drop _merge

sort yr_month asecflag faminc gr serial
set seed 126
bysort yr_month asecflag faminc gr: gen rnum1 = floor(N*runiform()+1)
tempfile hh_level
save `hh_level', replace

*3) create a new ASEC sample with random ASEC income within each cell 
keep if asecflag==1 
set seed 126
bsample, strata(year ASECincgrp gr) 
drop rnum1 
sort year ASECincgrp gr yr_month serial
bysort year ASECincgrp gr: gen rnum1 = _n 
rename ASECfam_inc ifam_inc
keep year ASECincgrp gr rnum1 ifam_inc 
tempfile bsample
save `bsample', replace
restore 

*4) within a cell, assign the random draw of ASEC income to monthly CPS households 
preserve
use `hh_level', clear
replace ASECincgrp=faminc  //assign based on the Monthly CPS income bracket
merge m:1 year ASECincgrp gr rnum1 using `bsample'
* check whether there is missing cells in the ASEC data
tab faminc gr if _merge==1 & faminc<840
tab yr_month if _merge==1 & faminc<840
drop if _merge==2
keep yr_month asecflag serial ifam_inc
tempfile impute
save `impute', replace
restore

*5) merge this household level data to the original individual level data
merge m:1 yr_month asecflag serial using `impute'
drop _merge
* the imputed income (ifam_inc should fall into faminc for the monthly CPS sample 
bysort year asecflag faminc: sum ifam_inc   

 

*******************         End of the data cleaning           *****************
********************************************************************************
************                    Sample Restriction                 *************

** Keep householder's family only (95%)
keep if hfam==1
** keep non-imputed monthly income  (80%)
keep if faminc<990 & (qfaminc==0|qfaminc==.)  
** keep non-imputed ASEC earnings income (89%) 
sum qASECinc [w=asecwt] 
keep if qASECinc==0
** merge with the PCE 
merge m:1 yr_month using PCE
drop if _merge==2
drop _merge
replace ASECfam_inc = PCE*ASECfam_inc
replace ifam_inc = PCE*ifam_inc


* log income
gen lifam_inc = ifam_inc
gen lASECfam_inc = ASECfam_inc
replace lifam_inc=1 if ifam_inc<1
replace lASECfam_inc=1 if ASECfam_inc<1
gen ln_ifam_inc = log(lifam_inc)
gen ln_ASEC_inc = log(lASECfam_inc)


********************************************************************************
** Appendix Table 12: Variance and CV
preserve
keep if mish==3|mish==7|mish==4|mish==8
* 2019 data only
keep if year==2019
keep if ifam_inc!=. & ASECfam_inc!=.
putexcel set App.T12.xlsx, replace
putexcel B1 = "Monthly CPS"
putexcel C1 = "CPS ASEC"
putexcel A2 = "Mean"
putexcel A3 = "Standard Deviation"
putexcel A4 = "Variance"
putexcel A5 = "Coefficients of variation"
putexcel A6 = "Number of individuals"

sum ifam_inc 
putexcel B2 = `r(mean)'
putexcel B3 = `r(sd)'
putexcel B4 = `r(sd)'^2
putexcel B5 = `r(sd)'/`r(mean)'
putexcel B6 = `r(N)'
sum ASECfam_inc 
putexcel C2 = `r(mean)'
putexcel C3 = `r(sd)'
putexcel C4 = `r(sd)'^2
putexcel C5 = `r(sd)'/`r(mean)'
putexcel C6 = `r(N)'
restore

********************************************************************************
*** Appendix Table 3: ASEC income bracket by Monthly CPS income bracket    *****
** Fixed Reference Period
preserve
keep if mish==3|mish==7|mish==4|mish==8
egen tot_wgt = sum(asecwt)
bysort ASECincgrp: egen ASEC_wgt = sum(asecwt)
bysort faminc: egen Month_wgt = sum(asecwt)
bysort faminc ASECincgrp: egen wgt = sum(asecwt)
gen frac_ASEC = ASEC_wgt/tot_wgt
gen frac_Month = Month_wgt/tot_wgt
gen frac_cell = wgt/Month_wgt
collapse frac_cell frac_Month frac_ASEC, by(faminc ASECincgrp)
reshape wide frac_cell frac_ASEC, i(faminc) j(ASECincgrp)
order faminc frac_cell* frac_Month  
keep faminc frac_cell* frac_Month  
tempfile AppT3
save `AppT3', replace
restore 

preserve
keep if mish==3|mish==7|mish==4|mish==8
egen tot_wgt = sum(asecwt)
bysort ASECincgrp: egen ASEC_wgt = sum(asecwt)
gen frac_ASEC = ASEC_wgt/tot_wgt
collapse frac_ASEC, by(faminc ASECincgrp)
rename frac_ASEC frac_cell
keep if faminc==843
replace faminc=844
reshape wide frac_cell, i(faminc) j(ASECincgrp)
order faminc frac_cell* 
tempfile AT3
save `AT3', replace
restore 

preserve
use `AppT3', clear
append using `AT3'
export excel using App.T3.xlsx, keepcellfmt firstrow(var) replace 
restore

********************************************************************************
*** Appendix Table 4: Correlations 
********************************************************************************
** Panel A of Appendix Table 4: Fixed Reference Month
preserve
keep if mish==3|mish==7|mish==4|mish==8
* 2019 data only
keep if year==2019

putexcel set App.T4.xlsx, replace
putexcel A2 = "PanelA"
* Pearson correation 
pwcorr ln_ifam_inc ln_ASEC_inc, obs sig
putexcel B2 = "Pearson"
putexcel B3 = `r(rho)'
putexcel B4 = `r(N)'
* Spearman correation 
spearman ln_ifam_inc ln_ASEC_inc, stats(rho p obs)
putexcel C2 = "Spearman (Rank)"
putexcel C3 = `r(rho)'
putexcel C4 = `r(N)'

* correlation figure
label var ln_ifam_inc "Log(Monthly CPS Income)"
label var ln_ASEC_inc "Log(CPS ASEC Income)"
corr ln_ASEC_inc ln_ifam_inc 
local corr : di %5.3g r(rho) 
twoway (scatter ln_ASEC_inc ln_ifam_inc, legend(off) xtitle("Log(Monthly CPS Income)") subtitle("Correlation `corr'") msymbol(o) msize(vtiny) graphregion(fcolor(white)) bgcolor(white) legend(rows(3) region(lcolor(ltblue)))) (line ln_ASEC_inc ln_ASEC_inc) 
graph export "AppT4_PanelA.png", replace 
restore




********************************************************************************
** Panel B of Appendix Table 4: Fixed Survey Month
preserve
keep if mish==1|mish==5
* 2019 data only
keep if year==2019

putexcel set App.T4.xlsx, modify
putexcel A5 = "PanelA"
* Pearson correation 
pwcorr ln_ifam_inc ln_ASEC_inc, obs sig
putexcel B5 = "Pearson"
putexcel B6 = `r(rho)'
putexcel B7 = `r(N)'
* Spearman correation 
spearman ln_ifam_inc ln_ASEC_inc, stats(rho p obs)
putexcel C5 = "Spearman (Rank)"
putexcel C6 = `r(rho)'
putexcel C7 = `r(N)'

* correlation figure
label var ln_ifam_inc "Log(Monthly CPS Income)"
label var ln_ASEC_inc "Log(CPS ASEC Income)"
corr ln_ASEC_inc ln_ifam_inc 
local corr : di %5.3g r(rho) 
twoway (scatter ln_ASEC_inc ln_ifam_inc, legend(off) xtitle("Log(Monthly CPS Income)") subtitle("Correlation `corr'") msymbol(o) msize(vtiny) graphregion(fcolor(white)) bgcolor(white) legend(rows(3) region(lcolor(ltblue)))) (line ln_ASEC_inc ln_ASEC_inc) 
graph export "AppT4_PanelB.png", replace 
restore





********************************************************************************
** Panel C of Appendix Table 4: Correlations between Actual and Imputed ASEC Income

clear
cd "C:\Users\worri\Dropbox\Poverty\COVID19"
use Monthly_Poverty_0520.dta

** keep ASEC samples 
keep if asecflag==1

gen yr_month=year*100+month   
//keep if yr_month>=201901
** drop the 3/8 file in 2014 
drop if hflag==1 
** replace asecflag 2 => asecflag . 
replace asecflag=. if asecflag==2 

** drop irrelevant variables
drop hflag earnwt offcutoff qinc*d qoinc*d durunemp whyunemp whyabsnt wnlook wkstat wksworkorg occ ind classwkr earnwt earnweek
** deal with missing or N/A income data
replace inctot = 0 if inctot==999999999|inctot==.

********************************************************************************
******   Construct a family unit variable for Poverty measures, famnum    ******
** For the poverty measure, a primary family and realted family is considered as one family

/* Assign 1 to primary+realted families */
gen famnum = ftype==1|ftype==3 

/* Assign 2-4 to unrelated subfamilies */ 
sort yr_month asecflag serial ftype pernum
* Each subfamily has a reference person  (famrel==1)
//tab famrel if ftype==4
* Calculate # subfamilies in a household (Max 3 in this sample period)
bysort yr_month asecflag serial: egen tot_subfam = sum(ftype==4 & famrel==1)
tab tot_subfam if ftype==4 
sort yr_month asecflag serial ftype famrel
bysort yr_month asecflag serial ftype: gen subfamnum = sum(famrel==1)
tab subfamnum if ftype==4 
* Assign 2-4 to the 1st-3rd unrelated subfamily
replace famnum= subfamnum+1 if ftype==4 
drop subfamnum pernum

/* Assign 5-20 to non-family members (ftype=1,2 or famrel=0) */
* Calculate # non-family members within a household (Max 16 in this sample period)
bysort yr_month asecflag serial: gen non_fam = sum(famrel==0) 
tab non_fam 
* Assign 5-20 to the 1st-20th non-family member. 
replace famnum= non_fam+4 if famrel==0  
drop non_fam

* Construct demographic variables related to the poverty threshold 
* 1) family size
bysort yr_month asecflag serial famnum: gen fam_size = _N
* 2) related children under age 18 (excluding HH head or spouse)
bysort yr_month asecflag serial famnum: egen nchild = sum(age<18 & relate>=301)
* 3) the head is elderly (>=65)
bysort yr_month asecflag serial famnum: egen head_elderly = max(age>=65 & relate==101)
* 4) a few cases where all members are children -> change to one adult w/ two children 
replace nchild=nchild-1 if fam_size==nchild



********************************************************************************
** Construct the family income variable in category for the ASEC sample 

* 1) generate a flag variable for ASEC earnings 
bysort yr_month asecflag serial famnum: egen qASECinc = max(qinclong==1|qoincwage==1|qoincbus==1|qoincfarm==1)
drop qinclong qoincwage qoincbus qoincfarm
* 2) identify the HH head's family  
bysort yr_month asecflag serial famnum: egen hfam = sum(relate==101) 

* 3) calculate the Householder's family income
bysort yr_month asecflag serial: egen hfaminc = sum(inctot) if hfam==1
bysort yr_month asecflag serial: egen ASECfam_inc = max(hfaminc)
replace ASECfam_inc=. if asecflag!=1
drop inctot

* 4) create an income bracket variable based on the ASEC income value
* I will impute the income based on this variable 
gen ASECincgrp = . 
replace ASECincgrp = 100 if ASECfam_inc<5000 
replace ASECincgrp = 210 if ASECfam_inc>=5000 & ASECfam_inc<7500
replace ASECincgrp = 300 if ASECfam_inc>=7500 & ASECfam_inc<10000
replace ASECincgrp = 430 if ASECfam_inc>=10000 & ASECfam_inc<12500
replace ASECincgrp = 470 if ASECfam_inc>=12500 & ASECfam_inc<15000
replace ASECincgrp = 500 if ASECfam_inc>=15000 & ASECfam_inc<20000
replace ASECincgrp = 600 if ASECfam_inc>=20000 & ASECfam_inc<25000
replace ASECincgrp = 710 if ASECfam_inc>=25000 & ASECfam_inc<30000 
replace ASECincgrp = 720 if ASECfam_inc>=30000 & ASECfam_inc<35000
replace ASECincgrp = 730 if ASECfam_inc>=35000 & ASECfam_inc<40000 
replace ASECincgrp = 740 if ASECfam_inc>=40000 & ASECfam_inc<50000
replace ASECincgrp = 820 if ASECfam_inc>=50000 & ASECfam_inc<60000
replace ASECincgrp = 830 if ASECfam_inc>=60000 & ASECfam_inc<75000
replace ASECincgrp = 840 if ASECfam_inc>=75000 & year<=2004
replace ASECincgrp = 841 if ASECfam_inc>=75000 & ASECfam_inc<100000  & year>=2005
replace ASECincgrp = 842 if ASECfam_inc>=100000 & ASECfam_inc<150000 & year>=2005
replace ASECincgrp = 843 if ASECfam_inc>=150000 & year>=2005


** construct 15 demographic groups based on householder's family characteristics
gen gr=.
replace gr=1  if fam_size==1 & head_elderly==0
replace gr=2  if fam_size==1 & head_elderly==1
replace gr=3  if fam_size==2 & head_elderly==0 & nchild==0 
replace gr=4  if fam_size==2 & head_elderly==1 & nchild==0 
replace gr=5  if fam_size==2 & nchild==1
replace gr=6  if fam_size==3 & nchild==0
replace gr=7  if fam_size==3 & nchild==1
replace gr=8  if fam_size==3 & nchild==2
replace gr=9  if fam_size==4 & nchild<=1
replace gr=10 if fam_size==4 & nchild==2
replace gr=11 if fam_size==4 & nchild==3
replace gr=12 if fam_size==5 & nchild<=2
replace gr=13 if fam_size==5 & nchild>=3
replace gr=14 if fam_size==6 
replace gr=15 if fam_size>=7


********************************************************************************
** Family Income Imputation within income-demographic cell using the ASEC Income
*1) convert the data to the household level data  
preserve 
keep year yr_month asecflag serial relate ASECincgrp gr faminc ASECfam_inc qASECinc
* keep one obs per HH (head)
sort yr_month asecflag serial relate
bysort yr_month asecflag serial: keep if _n==1
* calculate the size of demographic cells in each ASEC income bracket 
bysort year ASECincgrp gr asecflag: gen ASEC_N = _N if asecflag==1 
bysort year ASECincgrp gr: egen N = max(ASEC_N) 
* the 2020 ASEC data is not available yet. Assign the 2019 ASEC number
bysort year ASECincgrp gr asecflag: gen ASEC_N19 = _N if asecflag==1 & year==2019
bysort ASECincgrp gr: egen ASECN19 = max(ASEC_N19) 
replace N= ASECN19 if year==2020
drop ASEC_N ASEC_N19 ASECN19 

*2) within a cell, assign to the CPS ASEC HH a random number btw 1 and N, where N is the size of each cell in the ASEC sample
* this random number will be used when assigning imputed ASEC income to ASEC households 
sort yr_month asecflag ASECincgrp gr serial
set seed 126
bysort yr_month asecflag ASECincgrp gr: gen rnum1 = floor(N*runiform()+1)
tempfile hh_level
save `hh_level', replace

*3) create a new ASEC sample with random ASEC income within each cell 
keep if asecflag==1 
set seed 126
bsample, strata(year ASECincgrp gr) 
* the 2020 ASEC data is not available yet. Assign the 2019 ASEC number
expand 2 if year==2019, gen(ASEC20)
replace year=2020 if ASEC20==1
drop rnum1 ASEC20
sort year ASECincgrp gr yr_month serial
bysort year ASECincgrp gr: gen rnum1 = _n 
rename ASECfam_inc ifam_inc
keep year ASECincgrp gr rnum1 ifam_inc 
tempfile bsample
save `bsample', replace
restore 

*4) within a cell, assign a random draw of ASEC income with the bracket to households 
preserve
use `hh_level', clear
merge m:1 year ASECincgrp gr rnum1 using `bsample'
drop if _merge==2
keep yr_month asecflag serial ifam_inc
tempfile impute
save `impute', replace
restore

*5) merge this household level data to the original individual level data
merge m:1 yr_month asecflag serial using `impute'
drop _merge
* the imputed income (ifam_inc should fall into faminc for the monthly CPS sample 
bysort year asecflag ASECincgrp: sum ifam_inc   

 

*******************         End of the data cleaning           *****************
********************************************************************************
************                    Sample Restriction                 *************

** Keep householder's family only (95%)
keep if hfam==1
** keep non-imputed monthly income  (80%)
keep if faminc<990 & (qfaminc==0|qfaminc==.)  
** keep non-imputed ASEC earnings income (89%) 
sum qASECinc [w=asecwt] 
keep if qASECinc==0
** merge with the PCE 
merge m:1 yr_month using PCE
drop if _merge==2
drop _merge
replace ASECfam_inc = PCE*ASECfam_inc
replace ifam_inc = PCE*ifam_inc


* log income
gen lifam_inc = ifam_inc
gen lASECfam_inc = ASECfam_inc
replace lifam_inc=1 if ifam_inc<1
replace lASECfam_inc=1 if ASECfam_inc<1
gen ln_ifam_inc = log(lifam_inc)
gen ln_ASEC_inc = log(lASECfam_inc)


********************************************************************************
preserve
keep if mish==3|mish==7|mish==4|mish==8
* 2019 data only
keep if year==2019

putexcel set App.T4.xlsx, modify
putexcel A8 = "PanelC"
* Pearson correation 
pwcorr ln_ifam_inc ln_ASEC_inc, obs sig
putexcel B8 = "Pearson"
putexcel B9 = `r(rho)'
putexcel B10 = `r(N)'
* Spearman correation 
spearman ln_ifam_inc ln_ASEC_inc, stats(rho p obs)
putexcel C8 = "Spearman (Rank)"
putexcel C9 = `r(rho)'
putexcel C10 = `r(N)'
restore


** Correlation Figure
preserve 
keep if mish==3|mish==7|mish==4|mish==8
* 2019 data only
keep if year==2019
label var ln_ASEC_inc "Log(Actual CPS ASEC Income)"
label var ln_ifam_inc "Log(Imputed CPS ASEC Income)"
corr ln_ASEC_inc ln_ifam_inc 
local corr : di %5.3g r(rho) 
twoway (scatter ln_ifam_inc ln_ASEC_inc, legend(off) xtitle("Log(Actual CPS ASEC Income)") ytitle("Log(Imputed CPS ASEC Income)") subtitle("Correlation `corr'") msymbol(o) msize(vtiny) graphregion(fcolor(white)) bgcolor(white) legend(rows(3) region(lcolor(ltblue)))) (line ln_ASEC_inc ln_ASEC_inc) 
graph export "AppT4_PanelC.png", replace 
restore
